/******************************************************************************/
#include "stdafx.h"
/******************************************************************************/
const Bool hi_quality=true; // change to false to disable hi-quality settings
/******************************************************************************/
Mshg  terrain; // terrain mesh
Mesh  tree[4]; // tree    mesh
Grass grass  ; // grass   renderer

Grass::Elm grass_elm   [hi_quality ? 5000 : 3000]; // single grass element
Matrix      tree_matrix[hi_quality ?   20 :   10]; // tree  matrixes
/******************************************************************************/
void InitPre()
{
   App.name="Nature";
   App.flag=APP_MS_EXCLUSIVE|APP_FULL_TOGGLE;
   IOPath="../data/";
   PakAdd("engine.pak");

   D.full(true).ambPower(0.35).hwDepthBuffer(true).shdMode(SHD_MAP_HW);

   if(hi_quality)
   {
      D.hdr(true).hpRt(true).bumpMode(BUMP_PARALLAX).hdrExposure(0.7).bloomOverbright(true)
       .ambMode(AMB_LOW).ambRange(0.05).ambHalfRes(true)
       .shdSoft(1).shdMapSize(1024).shdJitter(true).grassShadow(true)
       .mtnMode(MTN_HIGH);

      ViewportFull.range=50;
   }else
   {
      D.bendLeafs(false);
      ViewportFull.range=35;
   }
}
/******************************************************************************/
Bool Init()
{
   Cam.dist=6;
   Cam.at.set(0,2,0);
   Sky.set();

   // set sun
   Sun.set(*Gfxs("gfx/sky/sun.gfx"));
   Sun.power=1-D.ambPower();
   Sun.rays.mode=(hi_quality ? SUN_RAYS_HIGH : SUN_RAYS_LOW);

   // set water
   if(hi_quality)
   {
      Water.set  (*Gfxs("gfx/water/0.gfx"),*Gfxs("gfx/water/0.n.gfx"),Gfxs("gfx/fx/reflection.gfx"));
      Water.plane(Water.plane()-Vec(0,0.8,0));
      Water.wave_scale=0.3;
   }

   // load clouds
   Clouds.layered.set(3,Gfxs("Clouds/Layers/0.gfx"));

   // load terrain mesh
   terrain.load("obj/terrain/0.mshg");

   // create tree meshes
   Memb<Material*> leaf_materials;
   leaf_materials.New()=Materials("mtrl/leaf/0/0.mtrl");
   leaf_materials.New()=Materials("mtrl/leaf/0/1.mtrl");
   REPA(tree)tree[i].createTree(Materials("mtrl/bark/0.mtrl"),leaf_materials).scale(Vec(0.5)).setRender();

   // create grass renderer
   grass.create();

   // set tree matrixes
   REPA(tree_matrix)
   {
      tree_matrix[i].setRotateY(RndF(PI2));                             // set matrix from random Y rotation
      PosPointMeshY(Rnd(terrain.box).xz(),terrain,&tree_matrix[i].pos); // set random position on surface
      tree_matrix[i].pos.y-=0.1;                                        // move it down a little
   }

   // set random grass matrixes
   terrain.setFaceNormals(); // make sure terrain has face normals, since we'll need those later
   REPA(grass_elm)
   {
      Grass::Elm &elm    =grass_elm[i];
      Matrix      &matrix=elm.matrix;
                          elm.param.set(0,0,0,Rnd(16,128)); // set parameters

      matrix.setScale(Vec(0.18,0.3,0.18)).rotateY(RndF(PI2)); // set scaled matrix and rotate it

      Vec start  =Rnd(terrain.box); // set random position at top of the terrain mesh box
          start.y=terrain.box.max.y;

      I32 hit_face,hit_mshb,hit_mesh;
      if(CutsPOINTMesh(start,-Vec(0,terrain.box.h(),0),terrain,NULL,NULL,&matrix.pos,&hit_face,&hit_mshb,&hit_mesh)) // cast a ray down-wards and store contact info
      {
         Mshb &mshb=terrain.M(hit_mesh).B(hit_mshb);                                                   // this is the Mshb that we've hit
         Vec  &nrm =((hit_face&SIGN_BIT) ? mshb.quad.nrm[hit_face^SIGN_BIT] : mshb.tri.nrm[hit_face]); // this is the face normal that we've hit
         matrix.orn  *=Matrix3().setUp(nrm);                                                           // transform our grass matrix according to surface normal
         matrix.pos.y-=0.05;                                                                           // move it down a little
      }
   }

   return true;
}
/******************************************************************************/
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;
   CamHandle(0.1,100,CAMH_ZOOM|(Ms.b(0)?CAMH_MOVE_XZ:(Ms.b(1)?CAMH_MOVE:CAMH_ROT))); // move camera on left/right mouse button
   Clouds.layered.update();
   Water .        update(Vec2(0.2));
   UpdateGrassAndLeafs();

   if(Kb.bp(KB_F10))Renderer.screenShots("ScreenShot/%d.bmp");

   return true;
}
/******************************************************************************/
void Render()
{
   switch(Renderer())
   {
      case RM_SHD_MAP:
      case RM_SOLID  :
      case RM_SOLID_M:
         terrain.draw(MatrixIdentity);                             // render terrain
         REPA(tree_matrix)tree[i%ELMS(tree)].draw(tree_matrix[i]); // render trees
         grass.draw(grass_elm,ELMS(grass_elm));                    // render grass
      break;
   }
}
void Draw()
{
   Renderer(Render);
   D.text(0,0.9,S+"Fps "+Tm.fps);
}
/******************************************************************************/
